module testmem

implicit none
save

integer, parameter :: q=kind(0.d0)

integer :: N=5000

real(q), allocatable :: arr1(:)
complex(q), allocatable :: arr2(:)
integer, allocatable :: arr3(:,:)

integer :: tag_arr1=0
integer :: tag_arr2=0
integer :: tag_arr3=0

contains

   subroutine subroutine1()
       use  MemoryManager, only: LogMemAlloc,LogMemDealloc
       integer :: err
       character(*), parameter :: thisroutine='subroutine1'

       allocate(arr1(N),stat=err)
       call LogMemAlloc('arr1',N,8,thisroutine,tag_arr1,err)

       allocate(arr2(2*N),stat=err)
       call LogMemAlloc('arr2',2*N,16,thisroutine,tag_arr2,err)

       deallocate(arr1,stat=err)
       call LogMemDealloc(thisroutine,tag_arr1,err)

       allocate(arr1(N),stat=err)
       call LogMemAlloc('arr1',N,8,thisroutine,tag_arr1,err)
       deallocate(arr1,stat=err)
       call LogMemDealloc(thisroutine,tag_arr1,err)

       allocate(arr1(N),stat=err)
       call LogMemAlloc('arr1',N,8,thisroutine,tag_arr1,err)
       deallocate(arr1,stat=err)
       call LogMemDealloc(thisroutine,tag_arr1,err)

   end subroutine subroutine1

   subroutine subroutine2()
       use  MemoryManager, only: LogMemAlloc,LogMemDealloc
       integer :: err
       character(*), parameter :: thisroutine='subroutine2'

       deallocate(arr2,stat=err)
       call LogMemDealloc(thisroutine,tag_arr2,err)

       allocate(arr1(N),stat=err)
       call LogMemAlloc('arr1',N,8,thisroutine,tag_arr1,err)

       allocate(arr3(2*N,2*N),stat=err)
       call LogMemAlloc('arr3',4*N**2,4,thisroutine,tag_arr3,err)
       deallocate(arr3,stat=err)
       call LogMemDealloc(thisroutine,tag_arr3,err)


   end subroutine subroutine2

end module

program testmemory

use testmem, only: subroutine1,subroutine2
use MemoryManager, only: InitMemoryManager,LeaveMemoryManager

write (6,'(/a9/)') 'Welcome.'

call InitMemoryManager()

write (6,'(/a16)') 'This is a test.'

call subroutine1()
call subroutine2()

call LeaveMemoryManager()

write (6,'(/a10/a9)') 'All done.','Goodbye.'

end program testmemory
