module m

use timing, only: timer, set_timer, halt_timer

implicit none

contains

    subroutine t1()
        integer :: i
        real :: r,j
        type(timer), save :: proc_timer
        proc_timer%timer_name = 't1'
        call set_timer(proc_timer)
        call random_seed()
        call random_number(r)
        do i=1,100000000
            j=sin(r*i)
        end do
        call halt_timer(proc_timer)
    end subroutine t1

    subroutine t2()
        integer :: i
        real :: r,j
        type(timer), save :: proc_timer
        proc_timer%timer_name = 't2'
        call set_timer(proc_timer)
        call random_number(r)
        do i=1,1000000
            j=sin(r**2*i)
        end do
        do i=1,3
            call t3()
        end do
        call halt_timer(proc_timer)
    end subroutine t2

    subroutine t3()
        integer :: i
        real :: r,j
        type(timer), save :: proc_timer
        proc_timer%timer_name = 't3'
        call set_timer(proc_timer)
        call random_number(r)
        do i=1,1000000
            j=exp(tanh(r**2*i))
        end do
        call halt_timer(proc_timer)
    end subroutine t3

end module m

program example

use m
use timing, only: init_timing, end_timing, print_timing_report

call init_timing()

call t1()
call t2()
call t2()

call end_timing()
call print_timing_report()

end program example
